import matplotlib.pyplot as plt
import numpy as np
import os
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import math
from matplotlib import gridspec
import matplotlib.ticker as ticker
from matplotlib.ticker import ScalarFormatter
SMALL_SIZE = 12
MEDIUM_SIZE = 15
BIGGER_SIZE = 16
# Convert degrees to radians
angle_in_degrees = 30
angle_in_radians = math.radians(angle_in_degrees)

# Calculate cosine
cosine_value = math.cos(angle_in_radians)
y_solid_air=1
y_liquid_air=1
y_solid_liquid=1-cosine_value
# Set font to Helvetica
plt.rcParams["font.family"] = "Helvetica"
plt.rcParams["pdf.fonttype"] = 42  # Embed the font in the PDF file
n = 9
colors = plt.cm.rainbow(np.linspace(0, 1, n))
fitted_slope = []
fitted_intercept = []
length=[]
a = []
F = []
k=0


folder_path ='/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Data_nanoparticle_adhesion/Contact_angle_interface_energy_SI'
def see_force (input_file, k, shift_by_final):
    # Get the name of the input file as a string
    curve_full_name = str(input_file)
    curve_name = str(curve_full_name.split('_')[-4])

    print('strat processing', curve_full_name)

    f = open(input_file, "r")
    lines=f.readlines()
    energy=[]
    solid_air = []
    solid_liquid = []
    liquid_air = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])
        solid_air.append(x.split('\t')[-3])
        solid_liquid.append(x.split('\t')[-2])
        liquid_air.append(x.split('\t')[-1])

    solid_air_correct=[]
    liquid_air_correct = []
    solid_liquid_correct = []
    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))
    for ai in solid_air:
        solid_air_correct.append(float((ai.strip())))
    for aj in liquid_air:
        liquid_air_correct.append(float((aj.strip())))
    for ak in solid_liquid:
        solid_liquid_correct.append(float((ak.strip())))


    print(position_corrected)
    print(energy_corrected)

    print('position', len(position))
    print('energy', len(energy))

    array_solid_air = np.array(solid_air_correct)
    array_solid_liquid = np.array(solid_liquid_correct)
    array_liquid_air=np.array(liquid_air_correct)
    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 3)::])
    array_position = np.array(position_corrected)
    chopped_position = array_position[0:-1]
    print("lenchopped_position", len(chopped_position))
    print(array_position)
    print(array_energy)
    sp_fit_cut = array_energy.argmax()

    plt.figure(1,figsize=(4,4))



    print('hi')
    s_fit = 1
    tck = interpolate.splrep(array_position[:sp_fit_cut+1], shifted_energy[:sp_fit_cut+1], s=s_fit)

    print("here",array_position[sp_fit_cut])

    xnew = np.linspace(array_position[0], array_position[sp_fit_cut], 100)

    print('black', array_position[sp_fit_cut])
    print('red',xnew[-1])


    return array_position,array_energy,array_solid_air,array_liquid_air,array_solid_liquid

 # List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('.txt') and f.startswith('3107_ca_condition_0.0002_cone_angle_26_contact_angle_30_cone_cut_0.0075.txt')]

def myFunc(file_name):

  return float(str(file_name.split('_')[-4]))

print('check', math.cos(math.radians(60)))
y_lg=1
y_sg=1
y_sl=1-math.cos(math.radians(30))
simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(26) / 2))
Norm_factor_position = simulation_blunt_length
Norm_factor_energy =simulation_blunt_length*simulation_blunt_length*y_lg



# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)

print('file_list', txt_files)
fig = plt.figure(figsize=(2.5, 5))
gs = gridspec.GridSpec(4, 1, height_ratios=[1,1,1,1.5], hspace=0)
# fig.suptitle('CA=30')
k = 0

for i, txt_file in enumerate(txt_files):
    position_value = float(str(txt_file.split('_')[-4]))
    if position_value in range(10, 105, 1):  # Check if the value is in the range 14, 16, 18, ..., 32
        input_file = txt_file
        array_position,array_energy,array_solid_air,array_liquid_air,array_solid_liquid=see_force(input_file, k, shift_by_final='TRUE')

        ax4 = plt.subplot(gs[3])
        plt.plot(array_position/Norm_factor_position, array_energy/Norm_factor_energy, '-',
                 color='black', label='E', linewidth=1.0)
        plt.legend(loc=7,frameon=False)
        ax4.set_xticks([0, 4,8])
        # plt.yticks([0.0131,0.0134])
        ax3 = plt.subplot(gs[2], sharex=ax4)
        plt.plot(array_position/Norm_factor_position, array_liquid_air/Norm_factor_energy, '-',
                 color='b', label = 'E$_{LF}$', linewidth=1.0)
        print('liquid-air',array_liquid_air)
        plt.setp(ax3.get_xticklabels(), visible=False)
        # plt.yticks([0.0113,0.0115])
        plt.legend(loc=7,frameon=False)
        ax2 = plt.subplot(gs[1], sharex=ax4)
        plt.plot(array_position/Norm_factor_position, array_solid_liquid/Norm_factor_energy, '-',
                 color='red', label = 'E$_{SL}$', linewidth=1.0)

        plt.setp(ax2.get_xticklabels(), visible=False)


        plt.legend(loc=7,frameon=False)
        ax1 = plt.subplot(gs[0], sharex=ax4)
        plt.plot(array_position/Norm_factor_position, array_solid_air/Norm_factor_energy, '-',
             color='green', label='E$_{SF}$', linewidth=1.0)

        plt.setp(ax1.get_xticklabels(), visible=False)
        plt.legend(loc=7,frameon=False)


        k += 1
    else:
        input_file = txt_file
        array_position,array_energy,array_solid_air,array_liquid_air,array_solid_liquid=see_force(input_file, k, shift_by_final='TRUE')
        k += 1

plt.xlim(-0.005/Norm_factor_position,0.015/Norm_factor_position)
ax4.xaxis.set_major_locator(plt.MaxNLocator(2))
ax4.yaxis.set_major_locator(plt.MaxNLocator(2))
ax1.yaxis.set_major_locator(plt.MaxNLocator(2))
ax2.yaxis.set_major_locator(plt.MaxNLocator(2))
ax3.yaxis.set_major_locator(plt.MaxNLocator(2))

plt.tight_layout()
save_name = 'cone_angle_26_ca_30_explain.eps'
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'
# plt.savefig(save_path+save_name, format='eps', bbox_inches='tight',dpi=1200)
plt.show()

